#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	


	[TestFixture]
	public class DAL_PatientTransfusionRequirement : BaseTest 
	{
		
		private DataTable _dtPatientTransfusionRequirement;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatientTransfusionRequirement = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientTransfusionRequirement WHERE RecordStatusCode = 'A'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetTransfusionRequirementsForPatient_Pass()
		{
			System.Guid patientGuid = (System.Guid)this._dtPatientTransfusionRequirement.Rows[0][TABLES.PatientTransfusionRequirement.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(patientGuid);

			Assert.AreEqual(20, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid), TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.TransfusionRequirementText), TABLES.PatientTransfusionRequirement.TransfusionRequirementText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode), TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.CreateDate), TABLES.PatientTransfusionRequirement.CreateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.CreateUser), TABLES.PatientTransfusionRequirement.CreateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.CreateDivisionCode), TABLES.PatientTransfusionRequirement.CreateDivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.AntibodyTypeId), TABLES.PatientTransfusionRequirement.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.AntigenTypeId), TABLES.PatientTransfusionRequirement.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.ComponentRequirementId), TABLES.PatientTransfusionRequirement.ComponentRequirementId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.InactivationComment), TABLES.PatientTransfusionRequirement.InactivationComment);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.InactivateDate), TABLES.PatientTransfusionRequirement.InactivateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.InactivateUser), TABLES.PatientTransfusionRequirement.InactivateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.InactivateDivisionCode), TABLES.PatientTransfusionRequirement.InactivateDivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.RecordStatusCode), TABLES.PatientTransfusionRequirement.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.RowVersion), TABLES.PatientTransfusionRequirement.RowVersion);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.LastUpdateDate), TABLES.PatientTransfusionRequirement.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.SpecimenTestGuid), TABLES.PatientTransfusionRequirement.SpecimenTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionRequirement.VistaConversionIndicator), TABLES.PatientTransfusionRequirement.VistaConversionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.CompatibilityPercentage), TABLES.AntibodyParameter.CompatibilityPercentage);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
		}

		[Test]
		public void GetTransfusionRequirementsForPatient_Fail()
		{
			DataTable dtTest = DAL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetTransfusionRequiremetsForAllPatient_Pass()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);

			DataTable dtTest = DAL.PatientTransfusionRequirement.GetTransfusionRequiremetsForAllPatient(startDate, endDate);

			Assert.AreEqual(true, dtTest.Columns.Count == 12, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.ABORhDate), ARTIFICIAL.ABORhDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORhDivision), ARTIFICIAL.ABORhDivision);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.Category), ARTIFICIAL.Category);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.RequirementText), ARTIFICIAL.RequirementText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.DateEntered), ARTIFICIAL.DateEntered);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
		}

		[Test]
		public void GetTransfusionRequiremetsForAllPatient_Fail()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(1);
			System.DateTime endDate = System.DateTime.Now.AddYears(-1);

			DataTable dtTest = DAL.PatientTransfusionRequirement.GetTransfusionRequiremetsForAllPatient(startDate, endDate);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

	}
}

#endif

